Imports System.IO

Module Module1

    Sub Main()
        ' Crer un nouvel objet directoryinfo que nous allons utiliser.
        Dim dir As DirectoryInfo = New DirectoryInfo("C:\WinNT")

        ' Dump directory information.
        Console.WriteLine("***** Information sur un rpertoire *****")
        Console.WriteLine("Nom complet: {0}", dir.FullName)
        Console.WriteLine("Nom: {0}", dir.Name)
        Console.WriteLine("Parent: {0}", dir.Parent)
        Console.WriteLine("Date de cration: {0}", dir.CreationTime)
        Console.WriteLine("Attributs: {0}", dir.Attributes.ToString())
        Console.WriteLine("Racine: {0}", dir.Root)
        Console.WriteLine("**************************")



        ' Examiner le contenu du disque dur,
        ' et rechercher des fichiers bitmaps.
        Dim bitmapFiles() As FileInfo = dir.GetFiles("*.bmp")

        Console.WriteLine("{0} fichiers *.bmp ont t trouvs", bitmapFiles.Length)
        Dim f As FileInfo
        For Each f In bitmapFiles
            ' Maintenant on affiche des informations sur ces fichiers.
            Console.WriteLine("***************************")
            Console.WriteLine("Nom du fichier: {0}", f.Name)
            Console.WriteLine("Taille du fichier: {0}", f.Length)
            Console.WriteLine("Date de cration: {0}", f.CreationTime)
            Console.WriteLine("Attributs: {0}", f.Attributes.ToString())
            Console.WriteLine("***************************")
        Next

        ' Maintenant cration d'un nouveau rpertoire dans c:\WinNT:
        Try
            ' Cration de C:\WinNT\MyFoo
            Dim d As DirectoryInfo = dir.CreateSubdirectory("MyFoo")
            Console.WriteLine("Cr: {0}", d.FullName)

            ' Cration de C:\WinNT\MyBar\MyQaaz
            d = dir.CreateSubdirectory("MyBar\MyQaaz")
            Console.WriteLine("Cr: {0}", d.FullName)
        Catch e As IOException
            Console.WriteLine(e.Message)
        End Try

        ' Maintenant on appelle des membres partags...
        ' On rcupre tous les lecteurs.
        Dim drives() As String = Directory.GetLogicalDrives()
        Console.WriteLine("Voici vos lecteurs:")
        Dim s As String
        For Each s In drives
            Console.WriteLine("--> {0}", s)
        Next

        ' Maintenant on dtruit ce que l'on a fait.
        Console.WriteLine("Effacement de -> {0}\MyBar\MyQaaz.", _
            dir.FullName)
        Console.WriteLine("et de -> {0}\MyFoo.", dir.FullName)
        Console.WriteLine("Appuyer sur une touche pour continuer!")
        Console.Read()

        ' Effacement...
        Try
            Directory.Delete("C:\WinNT\MyFoo")
            Directory.Delete("C:\WinNT\MyBar", True)
        Catch e As IOException
            Console.WriteLine(e.Message)
        End Try
    End Sub
End Module
